local assets =
{
    Asset("ANIM", "anim/huhu.zip"),
	Asset("ATLAS", "images/inventoryimages/huhu.xml"),
}

local prefabs =
{
    "flies",
    "poopcloud",
}


local function FuelTaken(inst, taker)
    SpawnPrefab("poopcloud").Transform:SetPosition(taker.Transform:GetWorldPosition())
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("huhu")
    inst.AnimState:SetBuild("huhu")
    inst.AnimState:PlayAnimation("build")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.AnimState:PushAnimation("idle", false)

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst:AddComponent("stackable")

    inst:AddComponent("fertilizer")
    inst.components.fertilizer.fertilizervalue = TUNING.POOP_FERTILIZE
    inst.components.fertilizer.soil_cycles = TUNING.POOP_SOILCYCLES
    inst.components.fertilizer.withered_cycles = TUNING.POOP_WITHEREDCYCLES

    inst:AddComponent("smotherer")
    inst.components.inventoryitem.imagename = "huhu"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/huhu.xml"

    inst.flies = inst:SpawnChild("flies")
    inst:AddComponent("tradable")
    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.MED_FUEL
    inst.components.fuel:SetOnTakenFn(FuelTaken)

    MakeSmallBurnable(inst, TUNING.MED_BURNTIME)
    MakeSmallPropagator(inst)

    MakeHauntableLaunchAndIgnite(inst)

    return inst
end

return Prefab("huhu", fn, assets, prefabs)
